/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.GameUtil;

@Mod.EventBusSubscriber(modid="silentlib", value={Side.CLIENT})
public final class ClientTicks {
    @Deprecated
    public static final ClientTicks INSTANCE = new ClientTicks();
    private static final int QUEUE_OVERFLOW_LIMIT = 200;
    private static volatile Queue<Runnable> scheduledActions = new ArrayDeque<Runnable>();
    public static int ticksInGame = 0;
    public static float partialTicks = 0.0f;
    public static float deltaTicks = 0.0f;
    public static float totalTicks = 0.0f;

    private ClientTicks() {
    }

    public static void scheduleAction(Runnable action) {
        if (GameUtil.isClient()) {
            scheduledActions.add(action);
        } else {
            SilentLib.LOGGER.error("Tried to add client tick action on server side? {}", (Object)action);
        }
        if (scheduledActions.size() >= 200) {
            SilentLib.LOGGER.warn("Too many client tick actions queued! Currently at {} items. Would have added '{}'.", (Object)scheduledActions.size(), (Object)action);
            SilentLib.LOGGER.catching((Throwable)new IllegalStateException("ClientTicks queue overflow"));
            scheduledActions.clear();
        }
    }

    @SubscribeEvent
    public static void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ClientTicks.runScheduledActions();
        ClientTicks.updateTickCounters();
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
        }
    }

    private static void runScheduledActions() {
        Runnable action = scheduledActions.poll();
        while (action != null) {
            action.run();
            action = scheduledActions.poll();
        }
    }

    private static void updateTickCounters() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null || !gui.func_73868_f()) {
            ++ticksInGame;
            partialTicks = 0.0f;
        }
        float oldTotal = totalTicks;
        totalTicks = (float)ticksInGame + partialTicks;
        deltaTicks = totalTicks - oldTotal;
    }
}

